# smu: Stanislav Musil Utils

Home lab Swiss knife written in GO

[smu.dc5.cz](https://smu.dc5.eu)

<a href="https://smu.dc5.eu"><img alt="STMUSIL" src="https://img.shields.io/badge/OPENSOURCE BY-Stanislav MUSIL-131480?style=for-the-badge"></a>

## Planned Commands

- [X] argocd            ArgoCD Utils initial password
- [X] backup            Backup script
- [X] completion        Generate the autocompletion script for the specified shell
- [ ] debug-server      HTTP Server for debug & development
- [ ] df                System's "df" filtered for /dev devices and human readable
- [ ] docker            Docker Utils
- [ ] du                Own implemetation of "du"
- [ ] example-server    Run example web server
- [ ] expand            Expand environment variables in files and strings
- [ ] file-templates    Create common files from templates
- [ ] generate-docs     Generate Markdown docs
- [ ] generate-files    Generate dummy files for testing
- [X] git               Git Utils
- [ ] git-new           Create new gitlab repository in current dir
- [ ] git-addopt        Create new gitlab repository from current directory
- [ ] gitlab            Utils for Gitlab
- [ ] gitlab-ci         Utils for Gitlab CI
- [ ] go-code           Utils for writing Go code
- [ ] helm              Helm Utils
- [X] help              Help about any command
- [ ] host              Get IP from domain
- [ ] install-bin       Install Binary
- [ ] install-bin-tool  Install preconfigured binary tool like Terraform, Vault, ...
- [X] ip                Get my current IP address (using checkip.amazonaws.com)
- [ ] ip-local          Get local IP from network device
- [ ] k8s               Utils for Kubernetes
- [ ] login             Login to slu vault
- [ ] mail              Mail Utils
- [ ] mysql             MySQL Utils
- [ ] stan        Stan's Personal Utils
- [ ] postgres          Postgres Utils
- [X] random            Generate random string
- [X] ssh_utils         SSH Utils
- [ ] s3                S3 Utils
- [X] shell-scripts     Shell Scripts Utils Download ISO image
- [ ] upload            Upload file to S3
- [X] version           Prints version
- [ ] watch             Watch Util

## Run

```bash
./smu
```

## Docker

### build

```bash
docker build -t stmusil/smu .
````

### Upload to Docker Hub

```bash
docker push stmusil/smu
```

## go rebuild go.mod if needed (optional)

If you need to rebuild go.mod file, run the following commands:

```bash
rm go.mod
rm go.sum
go mod init smu
go mod tidy
````

## Build

```bash
go build
```

## RELEASE process for production

### Initialize goreleaser

goreleaser.yml must exists if not run "goreleaser init"

### Version bump

change version in version/version.go file (do not commit)

### Release

```bash
git add version/version.go
git commit -m "GoRelease"
git push
git tag # show all tags
git tag -a v0.1.0 -m "First release"
goreleaser release
```

### Create sha256

```bash
make sha256
```

### Create latest (copy to latest)

```bash
make latest
```

### Upload to web

```bash
make upload
```

### Update homebrew

#### show sha256 for Homebrew

```bash
make hb-sha256
```

#### Update Homebrew repository

modify smu.rb file in GitHub repo (version + SHA256sums)

[GitHub SMU Homebrew repo](https://github.com/musil/homebrew-tap)

Push changes to GitHub repository

```bash
git add Formula/smu.rb
git commit -m "Update smu.rb to version 0.6.3"
git push
```

### Install to local Mac

```bash
brew install musil/tap/smu
```

or

```bash
deploy-local
```

### Update via homebrew on local computer

```bash
brew update
brew upgrade smu
```
